#include <QtGui>

 #include "tableAttributeDlg.h"

 #define MESSAGE \
     tableAttributeDlg::tr("<p>Message boxes have a caption, a text, " \
                "and any number of buttons, each with standard or custom texts." \
                "<p>Click a button to close the message box. Pressing the Esc button " \
                "will activate the detected escape button (if any).")

 tableAttributeDlg::tableAttributeDlg(QWidget *parent)
     : QDialog(parent)
 {
	rowCurrentCount = 0; 
	

	tablePage	= new NewTablePage(this);
	applyBtn	= new QPushButton(tr("Ȯ"));
	cancelBtn	= new QPushButton(tr(""));

	connect(applyBtn, SIGNAL(clicked()), this, SLOT(ClickApply()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(ClickCancel()));

	QHBoxLayout * BtnLayout = new QHBoxLayout;
	BtnLayout->addWidget(applyBtn);
	BtnLayout->addWidget(cancelBtn);
	BtnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);

    QVBoxLayout *TableLayout = new QVBoxLayout;
    TableLayout->addWidget(tablePage);
	TableLayout->addLayout(BtnLayout);
    setLayout(TableLayout);
	
	setGeometry(0,0,800,400);
	setWindowTitle(tr("̺ Ӽ ̾α"));
 }

 void tableAttributeDlg::ClickApply()
 {
	QMessageBox::StandardButton closeMessage;
     closeMessage = QMessageBox::warning(this, tr("ϱ"),
         tr("  մϴ.\n"
            " Ͻðڽϱ?"),
         QMessageBox::No | QMessageBox::Yes);

     if (closeMessage == QMessageBox::Yes)
		 accept ();
 }

  void tableAttributeDlg::ClickCancel()
 {
	       reject();
 }

